-- tracks "Petty Data"

local StatTracker = require "components.stattracker"

local fresh_data =
{
	decorscreenpage = 1,
	masteryscreenpage = 1,
	inventorychestscreenpage = 1,
	radialstatuspage = "EQUIPMENT",
	-- player follow status page
	-- Decor open page
	-- Mastery open page
	-- inventory chest open page
}

local PettyDataTracker = Class(StatTracker, function(self, inst)
	StatTracker._ctor(self, inst)
	self:SetDefaultData(fresh_data)

	self._ondecorpagechanged = function(_, data) self:SetDecorScreenPage(data.index) end
	self.inst:ListenForEvent("decorpagechanged", self._ondecorpagechanged)

	self._onmasterypagechanged = function(_, data) self:SetMasteryScreenPage(data.index) end
	self.inst:ListenForEvent("masterypagechanged", self._onmasterypagechanged)

	self._oninventorychestpagechanged = function(_, data) self:SetInventoryChestScreenPage(data.index) end
	self.inst:ListenForEvent("inventorychestpagechanged", self._oninventorychestpagechanged)

	self._onradiastatuspagechanged = function(_, data) self:SetRadialStatusPage(data.mode) end
	self.inst:ListenForEvent("radialstatuspagechanged", self._onradiastatuspagechanged)
end)

function PettyDataTracker:GetDecorScreenPage()
	return self:GetValue("decorscreenpage")
end

function PettyDataTracker:SetDecorScreenPage(page)
	self:SetValue("decorscreenpage", page)
end

function PettyDataTracker:GetMasteryScreenPage()
	return self:GetValue("masteryscreenpage")
end

function PettyDataTracker:SetMasteryScreenPage(page)
	self:SetValue("masteryscreenpage", page)
end

function PettyDataTracker:GetInventoryChestScreenPage()
	return self:GetValue("inventorychestscreenpage")
end

function PettyDataTracker:SetInventoryChestScreenPage(page)
	self:SetValue("inventorychestscreenpage", page)
end

function PettyDataTracker:GetRadialStatusPage()
	return self:GetValue("radialstatuspage")
end

function PettyDataTracker:SetRadialStatusPage(page)
	self:SetValue("radialstatuspage", page)
end

return PettyDataTracker
